# Abstract {#abstract .unnumbered}

The performance of Large Language Models (LLMs) in reasoning tasks depends heavily on prompt design, with Chain-of-Thought (CoT) and self-consistency being critical methods that enhance this ability. However, these methods do not fully exploit the answers generated by the LLM to guide subsequent responses. This paper proposes a new prompting method, named Progressive-Hint Prompting (PHP), that enables automatic multiple interactions between users and LLMs by using previously generated answers as hints to progressively guide toward the correct answers. PHP is orthogonal to CoT and self-consistency, making it easy to combine with state-of-the-art techniques to further improve performance. We conducted extensive and comprehensive experiments on seven benchmarks. The results show that PHP significantly improves accuracy while remaining highly efficient. For instance, with text-davinci-003, we observed a 4.2% improvement on GSM8K with greedy decoding compared to Complex CoT, and a 46.17% reduction in sample paths with self-consistency. With GPT-4 and PHP, we achieve state-of-the-art performances on SVAMP (89.1% `latex $\rightarrow$ ` 91.9%), GSM8K (92% `latex $\rightarrow$ ` 95.5%), AQuA (76.4% `latex $\rightarrow$ ` 79.9%) and MATH (50.3% `latex $\rightarrow$ ` 53.9%).

# Introduction

While Large Language Models (LLMs) have demonstrated remarkable performance across various NLP tasks [otter2020survey; qiu2020pre; chowdhary2020natural], their ability to reason is often perceived as a limitation that cannot be overcome merely by increasing the scale of the model [rae2021scaling; srivastava2022beyond]. Prompt engineering in large-scale models has shown comparable or superior performance to full training set fine-tuning in enhancing reasoning ability, while also being significantly more sample-efficient [kojima2022large; lewkowycz2022solving]. One area of research that aims to address this limitation is the use of Chain-of-Thought (CoT) approaches to promote intermediate reasoning steps [wei2022chain; zhou2022least; fu2022complexity]. Other works in this area, such as Least-to-Most [zhou2022least] and Complex CoT [fu2022complexity], have also explored this direction. Another area of research is self-consistency-related approaches. In comparison to CoT-related work that focuses on designing better prompts, self-consistency proposes to sample multiple answers from the LLMs and arrive at the correct answer through a majority vote [fu2022complexity]. This approach is further improved upon by complex-based selection [fu2022complexity]. CoT-related and self-consistency-related works can be seamlessly combined without any conflict.

<figure id="model" data-latex-placement="!ht">
[IMAGE: model.pdf]
<figcaption>Our proposed Progressive-Hint Prompting method combines the generated answers and questions for double-checking purposes, which is divided into two stages. In the first stage, we generate a <strong>base answer</strong> by passing to the LLM a concatenation of the current question and a <strong>base prompt</strong>, such as CoT or Complex CoT. In the second stage, we generate the <strong>subsequent answers</strong> via the corresponding <strong>progressive-hint prompt</strong>, such as Progressive-Hint Prompting CoT (PHP-CoT) or Progressive-Hint Prompting Complex CoT (PHP-Complex CoT), for the subsequent interaction. The interaction stops when two consecutive answers are the same. <span style="color: 7030A0">Purple Box</span>: The input of LLM. <span style="color: ED7D31">Orange Box</span>: The output of LLM.</figcaption>
</figure>

Prior research has not explored the potential of leveraging the outputs of LLM to refine reasoning paths iteratively. It stands to reason that similar to human cognition, LLM could benefit from reevaluating and adjusting its generated reasoning paths in order to correct errors and enhance overall performance. In this paper, we propose a new method named Progressive-Hint Prompting (PHP) that involves sequentially interacting with LLM to approach the correct answer gradually. The method operates as follows: (1) given a question, we ask the LLM to provide a Base Answer; (2) we combine the question and answer to re-ask the LLM and obtain the Subsequent Answer; (3) we repeat the operation in (2) until the answer is stable and does not change over the last two answers. PHP follows a human-like thought process where previous answers are leveraged as hints to arrive at the correct answer after re-evaluating the question.

Figure [1](#model){reference-type="ref" reference="model"} illustrates the proposed PHP framework. We use the base prompt to obtain the initial base answer, and then employ the PHP prompt for subsequent questions. If the current answer matches the previous answer, it is more likely to be correct, and we terminate the LLM inquiry. With Complex CoT and GPT-4, after adding PHP, the performance achieves SOTA with 91.9% on SVAMP [patel2021nlp], 95.5% on GSM8K [cobbe2021training], and 79.9% on AQuA [ling2017program] and 53.9% on MATH [hendrycks2021measuring].

In summary, our contributions are as follows:

- We propose a new method, Progressive-Hint Prompting (PHP), alongside CoT and self-consistency, for improving LLM reasoning abilities.

- We demonstrate the effectiveness of PHP through extensive experimentation, including baseline comparisons and ablation studies, using four LLMs, text-davinci-002 and text-davinci-003, GPT-3.5-Turbo and GPT-4 [brown2020language; ouyang2022training; openai2023gpt4].

- The experiment results show that our method can also improve performance with self-consistency.

- We believe that progressive-hint prompting represents an important step towards automatic sequential interaction with LLMs and hope that it inspires future research in this field.

# Related Work

**Emergent Abilities and Multi-Step Reasoning.** LLMs are particularly skilled at in-context learning, which involves adhering to the structure of prompts (typically few-shot) and completing corresponding tasks [brown2020language; chowdhery2022palm; shin2020autoprompt; liu2023pre]. Among the diverse range of language comprehension tasks, we are particularly interested in multi-step reasoning because it exhibits two unique features. Firstly, LLMs significantly outperform smaller models on multi-step reasoning tasks [wei2022chain], whereas their performance gains on tasks like sentiment classification can be limited [shin2020autoprompt]. Secondly, few-shot prompting outperforms full training set fine-tuning in multi-step reasoning tasks, even when conducted on LLMs [lewkowycz2022solving].

**Chain-of-Thought Reasoning.** Chain-of-thought (CoT) prompting [wei2022chain] is a prominent work that demonstrates the multi-step reasoning capacities of LLMs. This approach suggests that the reasoning ability can be elicited through a chain of thoughts, where an answer directly follows a question without intermediate reasoning steps. Least-to-Most prompting [zhou2022least], which follows the same research direction, divides reasoning into problem breakdown parts and problem answer parts and describes the reasoning steps in more detail. Similarly, the complex CoT [fu2022complexity] highlights the importance of prompt complexity and selects the most complex questions and their answers as prompts. To reduce the human workload, the Auto-CoT is proposed [zhang2022automatic]. Other works have found that using specific phrases like \"Let's think step by step\" [kojima2022large] can improve performance.

**Reasoning Path Extraction.** Previous research has investigated various task-specific methods for identifying reasoning paths, including constructing semantic graphs [xu2021exploiting], developing Recurrent Neural Network (RNN) models to retrieve reasoning paths from a Wikipedia graph [asailearning], using human-annotated reasoning paths on math problems for fine-tuning [cobbe2021training], or training an extractor with heuristic-based pseudo reasoning paths [chen2019multi]. A novel research work, named Self-Consistency [wang2022self], couples the generation of reasoning paths and a final answer by sampling from the decoder and using aggregation to retrieve the most consistent answer without extra modules. This approach has shown great promise, and it has the potential to outperform existing methods in terms of accuracy. Furthermore, the vote complex [fu2022complexity], rank and select samples via complexity, is proposed to improve the self-consistency performance. This approach is particularly useful when dealing with complex reasoning problems.

# Progressive-Hint Prompting

---

**Base Prompting (_e.g._ CoT)**\
Q: There are 15 trees in the grove. Grove workers will plant trees in the grove today. After they are done, there will be 21 trees. How many trees did the grove workers plant today?

A: There are 15 trees originally. Then there were 21 trees after the Grove workers planted some more. So there must have been 21 - 15 = 6 trees that were planted. The answer is 6.\
\
**Progressive-Hint Prompting 1: Hint is the correct answer**\
Q: There are 15 trees in the grove. Grove workers will plant trees in the grove today. After they are done, there will be 21 trees. How many trees did the grove workers plant today? [(Hint: The answer is near to [6]{style="color: red"})]{style="color: blue"}.

A: [We know the Answer Hints: [6]{style="color: red"}. With the Answer Hints: [6]{style="color: red"}, we will answer the question.]{style="color: blue"} There are 15 trees originally. Then there were 21 trees after the Grove workers planted some more. So there must have been 21 - 15 = 6 trees that were planted. The answer is 6.\
\
**Progressive-Hint Prompting 2: Hint is the incorrect answer**\
Q: There are 15 trees in the grove. Grove workers will plant trees in the grove today. After they are done, there will be 21 trees. How many trees did the grove workers plant today? [(Hint: The answer is near to [10, 8]{style="color: red"})]{style="color: blue"}.

A: [We know the Answer Hints: [10, 8]{style="color: red"}. With the Answer Hints: [10, 8]{style="color: red"}, we will answer the question.]{style="color: blue"} There are 15 trees originally. Then there were 21 trees after the Grove workers planted some more. So there must have been 21 - 15 = 6 trees that were planted. The answer is 6.

---

One salient aspect of humanity is our ability to not only think once, but to also double-check our answers. In this paper, we propose that this process can be simulated in language models by sequentially employing previous answers. In other words, a model can generate an answer and then combine this with the question for the next round of thinking. If the current answer is the same as the previous one, we can have confidence that the current answer is correct.

We have shown the Proposed Interaction in Figure [1](#model){reference-type="ref" reference="model"} and Prompt Design in Table [\[Progressive-Hint\]](#Progressive-Hint){reference-type="ref" reference="Progressive-Hint"}. We demonstrate the process of generating PHP-CoT prompts for a given CoT prompt in Table [\[Progressive-Hint\]](#Progressive-Hint){reference-type="ref" reference="Progressive-Hint"} and provide the complete prompt in the Appendix. Our pipeline is divided into two stages: (i) **base answer & base prompt**: the generation of the base answer via base prompts such as CoT or Complex CoT and (ii) **subsequent answer & PHP**: the subsequent interaction with the LLMs through corresponding progressive-hint prompts like Progressive-Hint Prompting CoT (PHP-CoT) or Progressive-Hint Prompting Complex CoT (PHP-Complex CoT). We propose a two-sentence structure for the PHP, consisting of a phrase indicating the proximity of the answer at the question part followed by a sentence rehearsing hints at answer part. For instance, to create a PHP prompt from a CoT prompt, we first add the phrase \"The answer is near to `latex $A_1, ..., A_p$ `\" after the initial question, where `latex $A_1, ..., A_p$ ` represent possible answers. Next, we introduce the hints in the beginning sentence of the potential answers: \"We know the Answer Hints: `latex $A_1, ..., A_p$ `. With the Answer Hints: `latex $A_1, ..., A_p$ `, we will answer the question.\".

**PHP Design Principle**: we should consider various situations of hints. When we ask LLM questions, we do not know what the answer will be so the hints are unknown. In this prompt design, we consider the following two potential situations: 1) The hints are the same as the correct answer: to be sure that the model can still get the correct answer when the hint is correct; 2) hints are not the same as the correct answer: to be sure that the model can jump out of the incorrect answer.

Adhering to the above guidelines, we utilize the Standard prompt, CoT prompt, and Complex CoT prompt to generate initial base answers, from which we can then develop the subsequent answer generation prompts, namely, **PHP-Standard** prompt, **PHP-CoT** prompt, and **PHP-Complex CoT** prompt, respectively. The stopping criterion in PHP is reached when two consecutive responses are identical, signaling the end of the interactive exchange.

Overall, this method represents a pipeline for improving the quality of responses and enhancing communication during question-answer scenarios.

# Experiments

**Datasets and Models.** We evaluate PHP on seven datasets (AddSub [hosseini2014learning], MultiArith [roy-roth-2015-solving], SingleEQ [koncel2015parsing], SVAMP [patel2021nlp], GSM8K [cobbe2021training], AQuA [ling2017program]) and MATH [hendrycks2021measuring]. We choose the datasets because we focus on the reasoning ability of the model. The utilized for both the Standard and CoT prompts are sourced from the original CoT paper [wei2022chain], whereas the prompt utilized for the Complex CoT [fu2022complexity] prompt is derived from the corresponding Complex CoT publication. Also, to validate our proposed method performance, we employ four models: text-davinci-002 and text-davinci-003, GPT-3.5-Turbo and GPT-4 [brown2020language; ouyang2022training; openai2023gpt4]. All models are employed via OpenAI API key.

**Prompts.** We have shown the proposed process pipeline in the Method part. We show all the prompts in the Appendix and supplementary materials.

## Main Results

The main results of our study are presented in Table [\[experiment_1\]](#experiment_1){reference-type="ref" reference="experiment_1"}, with all methods using greedy decoding (i.e. temperature = 0). Our findings indicate that the proposed PHP improves performance, particularly when working with powerful prompts and models.\
**PHP works better when the LLM is more powerful**. In terms of model power, our analysis indicates that PHP is most effective when applied with powerful models. Specifically, when examining CoT and Complex CoT prompts, we found that while text-davinci-002 generally yielded a performance improvement after adding hints, there were occasions when performance would decline. However, when we replaced text-davinci-002 with text-davinci-003, performance improvement became more consistent and significant. For example, PHP-Complex CoT using text-davinci-002 improved performance by 3.6%, but then increased further to 4.6% with text-davinci-003. Similarly, on AQuA dataset, using PHP-Complex CoT resulted in a performance drop of 0.4% with text-davinci-002 but a 1.2% improvement with text-davinci-003. The text-davinci-002 is finetuned with supervised instruction tuning, while the text-davinci-003 is finetuned with reinforcement learning. The improved performance with text-davinci-003 can be attributed to its enhanced power, making it better at understanding and employing the given hint.

<figure id="interaction_number">
<p>[IMAGE: Standard.pdf] [IMAGE: CoT.pdf] [IMAGE: Complex_CoT.pdf]</p>
<figcaption>The Interaction Number refers to the frequency at which we need to consult the LLM until we receive conclusive responses. With an analysis of various models and prompts, it has been observed that: 1) A stronger model leads to a decreased interaction number; 2) An improved prompt results in an increased interaction number.</figcaption>
</figure>

**PHP works better when the prompt is more powerful.** After analyzing our data, it was determined that the prompt's power has a significant impact on the performance of the system. Our experimental results revealed that while the inclusion of PHP produced modest improvements with standard prompts, CoT and Complex CoT prompts demonstrated substantial gains in performance. Particularly noteworthy is the fact that the most potent prompt, Complex CoT, exhibited the most substantial performance improvement in comparison to the Standard prompt and CoT prompt. This finding provides compelling evidence that a superior prompt leads to greater effectiveness of the system.

**The Interaction Number decreases when the model is more powerful and the prompt is less powerful.** The number of interactions refers to how many times the agent engages with the LLMs. The interaction number is one when the agent receives the first answer and increases to two for the second answer. In Figure [2](#interaction_number){reference-type="ref" reference="interaction_number"}, we illustrate the interaction number of various models and prompts. Our findings indicate that: 1) The interaction number for text-davinci-003 is typically lower than that of text-davinci-002 when given the same prompt. This is primarily due to the higher accuracy of text-davinci-003, resulting in a higher probability of the base answer and subsequent answers being correct, thus requiring fewer interactions to obtain the final correct answer; 2) When using the same models, the interaction number generally increases as the prompt becomes more powerful. This is because the LLMs achieves better reasoning ability when the prompt becomes more potent, allowing them to leverage the hints to jump out of the incorrect answers, and ultimately leading to a higher number of interactions required to reach the final answer.

## Impact of the Hint Quality

**The quality of the hint significantly affects the performance.** Shown in Table [\[experiment_2\]](#experiment_2){reference-type="ref" reference="experiment_2"}, to enhance the PHP-Standard, replacing the base prompt Standard with Complex CoT or CoT leads to a significant improvement in the final performance. For PHP-Standard, we observe that GSM8K performance amplifies from 16.0% with base prompt Standard to 50.2% with base prompt CoT and 60.3% with base prompt Complex CoT. Conversely, replacing the base prompt Complex CoT with Standard will reduce the final performance. For example, after replacing base prompt Complex CoT with Standard, the performance of PHP-Complex CoT drops from 71.6% to 65.5% on GSM8K dataset.

**Performance may further improve if PHP is not designed from the corresponding base prompt.** The results indicate that the CoT with PHP-Complex CoT achieved a high accuracy rate of 96.8% on the MultiArith dataset, surpassing the performance of the CoT with PHP-CoT. Similarly, the Complex CoT with PHP-CoT demonstrated a notable accuracy rate of 95.6% on the same dataset, outperforming the Complex CoT with PHP-Complex CoT. The rationale behind these findings is twofold: 1) the performance of CoT and Complex CoT are similar on all six datasets, and 2) since the Base answer is provided by CoT (or Complex CoT) and the subsequent answer is based on PHP-Complex CoT (or PHP-CoT), it is comparable to having two individuals collaborating to solve a problem. Therefore, in such circumstances, the system's performance may be further enhanced.

## Ablation Study

Furthermore, we conducted an ablation study to verify the criticality of the two sentences in answers: 1) P1: We know the Answer Hints `latex $A_1, ..., A_p$ `; 2) P2: With the Answer Hints `latex $A_1, ..., A_p$ `, we will answer the question. Moreover, we introduced a new type of prompt called CoT-Merge and Complex CoT-Merge. Firstly, we combined the original prompt with the PHP prompt into a single file. Subsequently, we utilized the same Merge Prompt for both the base answer and subsequent answers. Also, we prove that both correct and incorrect hints are necessary in prompt design.

**The Proposed P1 and P2 are necessary.** Incorporating the sentences P1 and P2 resulted in better performance for CoT with PHP across three of the six datasets. However, the significance of these two sentences became particularly apparent when we employed Complex CoT. With this method, better performance was achieved on five of the six datasets after adding P1 and P2. For instance, Complex CoT improved its performance from 78.0% to 80.0% on the SVAMP dataset, and from 68.3% to 71.6% on the GSM8K dataset. This highlights that sentences P1 and P2 can exhibit more potent abilities, particularly when the model's logical capacity is superior. Consequently, we can conclude that P1 and P2 will likely enhance model performance to a greater extent, particularly with more powerful prompts and models.

**Non-Merge based PHP is better than merge based PHP when prompts are more powerful.** Regarding the CoT with PHP-CoT, the initial answer is derived from the CoT prompt, and subsequently, the answer is obtained from the PHP-CoT. Notably, compared to other CoT-base methods, CoT-Merge achieves the best performance. However, compared to other Complex CoT-based methods, we observe that non-merge PHP-Complex CoT with both P1 and P2 achieves the best performance. Hence, when prompts are better, the performance of non-merge based method will be better than merge-based method.

**Both correct and incorrect hints are needed in the prompt design.** Table [\[hint_design\]](#hint_design){reference-type="ref" reference="hint_design"} demonstrates that the use of PHP was superior to its absence when the designed prompt included both correct and incorrect hints. Specifically, the provision of a correct hint in the prompt promoted the generation of answers that matched the given hint. Conversely, the provision of incorrect answers in the prompt encouraged the generation of alternative answers, with the aid of the given hint.

## Performance with Self-Consistency

As we discussed before, our proposed method can combine with CoT and self-consistency to further improve the model performance. The results are shown in Table [\[table_self_consistency\]](#table_self_consistency){reference-type="ref" reference="table_self_consistency"}. Following the self-consistency paper, we sample paths with numbers 5, 10, 20 and 40, and the model temperature 0.7.

**PHP further improves performance.** By utilizing similar prompts and sample path numbers, we discovered that our proposed PHP-CoT and PHP-Complex CoT always achieve superior performance when compared to CoT and Complex CoT, shown in Table [\[table_self_consistency\]](#table_self_consistency){reference-type="ref" reference="table_self_consistency"} and Figure [3](#self_consistency_interaction_number){reference-type="ref" reference="self_consistency_interaction_number"}. For instance, CoT with self-consistency was able to attain a 96.5% accuracy on the MultiArith dataset with a sample path of 10, 20 and 40. Therefore, we can conclude that the best performance by CoT with self-consistency is 96.5% with text-davinci-003. However, after implementing PHP, the performance skyrocketed to 97.1%. Similarly, we observed CoT with self-consistency on SVAMP, achieving the best accuracy of 83.3% with 20 sampled paths, and further improved to 83.7% upon implementing PHP. This illustrates that PHP could break the performance bottleneck and further improve performance.

<figure id="self_consistency_interaction_number" data-latex-placement="t">
<p>[IMAGE: self_consistency_CoT_of_MultiArith.pdf] [IMAGE: self_consistency_CoT_of_SVAMP.pdf] [IMAGE: self_consistency_Complex_CoT_of_GSM8K.pdf]</p>
<figcaption>We show the results: 1) CoT of MultiArith; 2) CoT of SVAMP; 3) Complex CoT of GSM8K. According to 1) and 2), we can see that PHP could further improve performance. With result 3), we found that the PHP could even reduce the cost of self-consistency.</figcaption>
</figure>

**PHP could reduce the cost of self-consistency.** Incorporating the PHP can also lead to cost reduction. It is widely acknowledged that self-consistency involves an increased number of reasoning paths, resulting in a higher cost. The Table [\[table_self_consistency\]](#table_self_consistency){reference-type="ref" reference="table_self_consistency"} illustrates that PHP can be an effective approach for reducing this cost, while still preserving performance gains. As shown in Figure [3](#self_consistency_interaction_number){reference-type="ref" reference="self_consistency_interaction_number"}, using Complex CoT with self-consistency, a 78.1% accuracy can be reached with 40 sample paths, while incorporating PHP reduces the required sample amount to 10```latex $\times$ ````<!-- -->`{=html}2.1531=21.531 paths, and results in an even better accuracy of 78.2%.

## Performance with Chat Model

In the previous section, we follow the previous work settings and employ text generation models for our experiments. With the release API of GPT-3.5-Turbo and GPT-4, we validate the performance of Complex CoT with PHP on the same six datasets. We use greedy decoding (i.e. temperature = 0) and Complex CoT as prompt for both models.

**Analyze GPT-3.5-Turbo.** As depicted in Table [\[gpt35-turbo\]](#gpt35-turbo){reference-type="ref" reference="gpt35-turbo"}, the proposed PHP enhances performance, improving 2.3% on GSM8K and 3.2% on AQuA. However, GPT-3.5-Turbo exhibits a reduced ability to adhere to prompts compared to text-davinci-003. We provide two examples to illustrate this point: a) In cases where the given hints are absent, GPT-3.5-Turbo fails to answer the question and responds with a statement such as, \"We cannot answer this question as the answer hint is missing. Please provide the answer hint to proceed.\". In contrast, text-davinci-003 autonomously generates and fills in the missing answer hint before addressing the question (as demonstrated in the Appendix); b) When more than ten hints are provided, GPT-3.5-Turbo may respond with \"We cannot determine the correct answer as multiple answer hints are given. Please provide only one answer hint for the question.\".

**Analyze GPT-4.** After deploying the GPT-4 model, we were able to achieve the new SOTA performance on the SVAMP, GSM8K, AQuA and MATH benchmarks. Our proposed PHP method consistently improves the performance of GPT-4. Furthermore, compared to the GPT-3.5-Turbo model, we observed a reduction in the number of interactions required by GPT-4, which aligns with the finding that \"The Interaction Number decreases when the model is more powerful.\"

# Conclusion

This paper introduces a novel approach named Progressive-Hint Prompting (PHP) for interacting with LLMs, which offers multiple advantages: 1) PHP achieves substantial performance improvements on math reasoning tasks, leading to state-of-the-art results on several reasoning benchmarks; 2) with more powerful models and prompts, PHP can better and consistently benefit the LLMs; 3) PHP can be easily combined with CoT and self-consistency to further improve performance.

To better enhance the progressive-hint prompting approach, future research endeavors can focus on improving the design of handcrafted hints in the question phase and prompt sentences in the answer part. Additionally, novel hints that aid the LLMs to reconsider the questions can be identified and extracted beside the answer.

# Implementation Details

We have provided the code in our supplementary materials.

# Limitation and Further Work

In this paper, we will explore the limitations of our proposed progressive-hint prompting technique and discuss possible avenues for further improvement.

**The Progressive-Hint Prompt is handcrafted.** Our proposed progressive-hint prompts are handcrafted by humans, similar to other related techniques such as Chain-Of-Thought and Complex Chain of Thought. As such, we aim to design Auto Progressive Hint in the future to improve its efficiency. For instance, we could continuously build and update the progressive hint during testing.

**The hint is defined as the answer.** In this paper, we defined the hint as the answer. However, we acknowledge that the concept of hint encompasses other possibilities generated by models. These hints may include model confidence, reasoning path, and even interaction number.

**The interaction number is at least two.** Our design requires at least two interactions to determine the final answers. Therefore, using greedy decoding (where the sample path is always 1) as opposed to self-consistency can increase costs. Going forward, we plan to employ a powerful model initially to obtain the base answer then rely on cheaper models for subsequent answers. This approach could help us reduce the overall cost.

# Broader Impacts

Progressive-Hint Prompting aims to enhance the reasoning ability of Large Language Models (LLMs) by utilizing previous answers. We believe that the integration of PHP with LLM can be applied in a variety of areas, including: 1) Assisting students, particularly those from low-income areas, in learning more effectively and obtaining accurate answers with the help of LLM and PHP; 2) Aiding mathematicians in solving complex mathematical problems; 3) and other reasoning-related applications. By leveraging PHP with LLM, we hope to improve the performance of these models and enable their use in various practical scenarios.

# Model Response with Different Hints

---

**Question:** 200 pounds of carrots will be distributed to 40 restaurants in a certain city. Each restaurant is to receive 2 pounds of carrots. How many pounds of carrots will not be used?\
**Hint: 0**.[We know the Answer Hints: [0]{style="color: red"}. With the Answer Hints: [0]{style="color: red"}, we will answer the question.]{style="color: blue"} Let's think step by step We know that 200 pounds of carrots are to be distributed to 40 restaurants. Each restaurant is to receive 2 pounds of carrots. Therefore, 40 restaurants x 2 pounds of carrots = 80 pounds of carrots. The total amount of carrots used is 200 pounds - 80 pounds = 120 pounds. The amount of carrots not used is 200 pounds - 120 pounds = 80 pounds. The answer is [0]{style="color: red"}

**Hint: 100**. [We know the Answer Hints: [100]{style="color: red"}. With the Answer Hints: [100]{style="color: red"}, we will answer the question.]{style="color: blue"} Let's think step by step We know that 200 pounds of carrots are to be distributed to 40 restaurants. Each restaurant will receive 2 pounds of carrots, so 40 restaurants x 2 pounds = 80 pounds of carrots. This means that 200 pounds of carrots - 80 pounds of carrots = 120 pounds of carrots will not be used. The answer is [120]{style="color: red"}

---

**Model Response with different hints.** When presented with the hint 100, the model accurately solves the question. Conversely, the model can be misled if the provided hint strays too far from the correct answer. For instance, when the hint is 0, the model calculates the amount of not used carrots is 80 pounds, outputs an answer of 0.

# Interaction Cases

In this section, we provide more interaction cases.

## Success Case

---

Question: James decides to run 3 sprints 3 times a week. He runs 60 meters each sprint. How many total meters does he run a week?\
A: Let's think step by step\
James runs 3 sprints 3 times a week, so he runs 3\*3 = 9 sprints a week.\
Each sprint is 60 meters, so he runs 9\*60 = 540 meters a week.\
The answer is 540.\
Question: James decides to run 3 sprints 3 times a week. He runs 60 meters each sprint. How many total meters does he run a week? [(Hint: The answer is near to [540]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [540]{style="color: red"}. With the Answer Hints: [540]{style="color: red"}, we will answer the question.]{style="color: blue"} Let's think step by step James runs 3 sprints 3 times a week. Each sprint is 60 meters, so he runs 3 x 60 = 180 meters each time. He runs 3 times a week, so he runs 180 x 3 = 540 meters each week. The answer is 540.

---

Question: Two track teams are competing against each other in a 4 by 400 meter relay; a race where each competing team has four members that each run 400 meters, or one lap, around a standard track. One of the two teams is very well-rounded and each of their members will run their 400 meter leg in precisely 55 seconds. The other team is less well-rounded; their first runner will run their 400 meter leg in 60 seconds then each subsequent runner will be 3 seconds faster than the previous runner. Using this information, how many seconds will the faster team win by?\
A: Let's think step by step\
The first team will take 4 x 55 seconds = 220 seconds to complete the race.\
The second team will take 60 + 57 + 54 + 51 = 222 seconds to complete the race.\
The first team will win by 220 - 222 = -2 seconds.\
The answer is -2.\
Question: Two track teams are competing against each other in a 4 by 400 meter relay; a race where each competing team has four members that each run 400 meters, or one lap, around a standard track. One of the two teams is very well-rounded and each of their members will run their 400 meter leg in precisely 55 seconds. The other team is less well-rounded; their first runner will run their 400 meter leg in 60 seconds then each subsequent runner will be 3 seconds faster than the previous runner. Using this information, how many seconds will the faster team win by? [(Hint: The answer is near to [-2]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [-2]{style="color: red"}. With the Answer Hints: [-2]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
The first team will finish in 55 seconds x 4 runners = 220 seconds.\
The second team will finish in 60 seconds + (3 seconds x 3 runners) = 75 seconds.\
The difference between the two teams is 220 - 75 = 145 seconds.\
The faster team will win by 145 seconds.\
The answer is 145 seconds.\
Question: Two track teams are competing against each other in a 4 by 400 meter relay; a race where each competing team has four members that each run 400 meters, or one lap, around a standard track. One of the two teams is very well-rounded and each of their members will run their 400 meter leg in precisely 55 seconds. The other team is less well-rounded; their first runner will run their 400 meter leg in 60 seconds then each subsequent runner will be 3 seconds faster than the previous runner. Using this information, how many seconds will the faster team win by? [(Hint: The answer is near to [-2, 145]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [-2, 145]{style="color: red"}. With the Answer Hints: [-2, 145]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step The first team will take 4 x 55 = 220 seconds to complete the race.\
The second team will take 60 + 57 + 54 + 51 = 222 seconds to complete the race.\
The first team will finish the race 2 seconds faster than the second team.\
The answer is -2.\
Question: Two track teams are competing against each other in a 4 by 400 meter relay; a race where each competing team has four members that each run 400 meters, or one lap, around a standard track. One of the two teams is very well-rounded and each of their members will run their 400 meter leg in precisely 55 seconds. The other team is less well-rounded; their first runner will run their 400 meter leg in 60 seconds then each subsequent runner will be 3 seconds faster than the previous runner. Using this information, how many seconds will the faster team win by? [(Hint: The answer is near to [-2, 145, -2]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [-2, 145, -2]{style="color: red"}. With the Answer Hints: [-2, 145, -2]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
The first team will run their 4 legs in 55 seconds each, so their total time will be 4 x 55 = 220 seconds.\
The second team's first runner will run their 400 meter leg in 60 seconds, then each subsequent runner will be 3 seconds faster than the previous runner.\
So the second runner will run in 57 seconds, the third runner in 54 seconds, and the fourth runner in 51 seconds.\
The total time for the second team will be 60 + 57 + 54 + 51 = 222 seconds.\
The difference in time between the two teams is 222 - 220 = 2 seconds.\
The faster team will win by 2 seconds.\
The answer is 2.\
Question: Two track teams are competing against each other in a 4 by 400 meter relay; a race where each competing team has four members that each run 400 meters, or one lap, around a standard track. One of the two teams is very well-rounded and each of their members will run their 400 meter leg in precisely 55 seconds. The other team is less well-rounded; their first runner will run their 400 meter leg in 60 seconds then each subsequent runner will be 3 seconds faster than the previous runner. Using this information, how many seconds will the faster team win by? [(Hint: The answer is near to [-2, 145, -2, 2]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [-2, 145, -2, 2]{style="color: red"}. With the Answer Hints: [-2, 145, -2, 2]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
The first team will run their 4 legs in 55 seconds each, for a total of 4 x 55 = 220 seconds.\
The second team will run their 4 legs in 60, 57, 54, and 51 seconds, for a total of 60 + 57 + 54 + 51 = 222 seconds.\
The difference between the two teams is 222 - 220 = 2 seconds.\
The faster team will win by 2 seconds.\
The answer is 2.\

---

Question: A shopkeeper in order to promote his new shop put a discount of 20% on all the items for one day. Now he must sell the items at original price the other day. By what percentage must he increase the price to original? Answer Choices: (A) 21% (B) 20% (C) 25% (D) 33% (E) 18%\
A: Let's think step by step\
The shopkeeper gave a discount of 20% on all the items.\
Therefore, the new price of the items = 80% of the original price.\
To get back to the original price, the shopkeeper must increase the price by (100% - 80%) = 20%.\
The answer is (B), 20%\
Question: A shopkeeper in order to promote his new shop put a discount of 20% on all the items for one day. Now he must sell the items at original price the other day. By what percentage must he increase the price to original? Answer Choices: (A) 21% (B) 20% (C) 25% (D) 33% (E) 18% [(Hint: The answer is near to [(B)]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [(B)]{style="color: red"}. With the Answer Hints: [(B)]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
Let the original price of the item be x.\
Then, the price after discount = x - (20/100)x = 0.8x\
To get the original price, the shopkeeper must increase the price by (100/80)% = 25%.\
The answer is (C), 25%\
Question: A shopkeeper in order to promote his new shop put a discount of 20% on all the items for one day. Now he must sell the items at original price the other day. By what percentage must he increase the price to original? Answer Choices: (A) 21% (B) 20% (C) 25% (D) 33% (E) 18% [(Hint: The answer is near to [(B), (C)]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [(B), (C)]{style="color: red"}. With the Answer Hints: [(B), (C)]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
Let the original price of the item be x.\
Then, the discounted price of the item = x - (20/100)x = 0.8x\
To get the original price, the shopkeeper must increase the price by (100/80)% = 25%.\
The answer is (C), 25%\

## Failure Case

---

Question: Every day, Wendi feeds each of her chickens three cups of mixed chicken feed, containing seeds, mealworms and vegetables to help keep them healthy. She gives the chickens their feed in three separate meals. In the morning, she gives her flock of chickens 15 cups of feed. In the afternoon, she gives her chickens another 25 cups of feed. How many cups of feed does she need to give her chickens in the final meal of the day if the size of Wendi's flock is 20 chickens?\
A: Let's think step by step\
In the morning, Wendi gives her flock of chickens 15 cups of feed. Each chicken gets 3 cups of feed, so 15 cups of feed is for 5 chickens.\
In the afternoon, Wendi gives her chickens another 25 cups of feed. Each chicken gets 3 cups of feed, so 25 cups of feed is for 8 chickens.\
So, in total, Wendi has fed 5+8=13 chickens.\
Since Wendi's flock is 20 chickens, she needs to feed 20-13=7 more chickens.\
Each chicken needs 3 cups of feed, so Wendi needs to give her chickens 7\*3=21 cups of feed in the final meal of the day.\
The answer is 21.

Question: Every day, Wendi feeds each of her chickens three cups of mixed chicken feed, containing seeds, mealworms and vegetables to help keep them healthy. She gives the chickens their feed in three separate meals. In the morning, she gives her flock of chickens 15 cups of feed. In the afternoon, she gives her chickens another 25 cups of feed. How many cups of feed does she need to give her chickens in the final meal of the day if the size of Wendi's flock is 20 chickens? [(Hint: The answer is near to [21]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [21]{style="color: red"}. With the Answer Hints: [21]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
Wendi feeds each of her chickens three cups of feed per day.\
In the morning, she gives her flock of chickens 15 cups of feed.\
This means that 15 cups of feed is enough for 5 chickens.\
In the afternoon, she gives her chickens another 25 cups of feed.\
This means that 25 cups of feed is enough for 8 chickens.\
So, she has already fed 13 chickens in the morning and afternoon.\
She has 20 chickens in total, so she needs to feed 20-13 = 7 more chickens.\
Each chicken needs 3 cups of feed, so she needs to give 7 chickens x 3 cups of feed = 21 cups of feed in the final meal of the day.\
The answer is 21.\

---

Question: A basket contains 25 oranges among which 1 is bad, 20% are unripe, 2 are sour and the rest are good. How many oranges are good?\
A: Let's think step by step\
There are 25 oranges in the basket, of which 1 is bad, 20% are unripe, and 2 are sour.\
This means that 1 + 20% + 2 = 23 oranges are not good.\
Therefore, 25 - 23 = 2 oranges are good.\
The answer is 2.\
Question: A basket contains 25 oranges among which 1 is bad, 20% are unripe, 2 are sour and the rest are good. How many oranges are good? [(Hint: The answer is near to [2]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [2]{style="color: red"}. With the Answer Hints: [2]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
There are 25 oranges in the basket.\
1 is bad, so there are 24 oranges left.\
20% of the oranges are unripe, so 20% of 24 = 4.8 oranges are unripe.\
2 oranges are sour, so there are 24-4.8-2 = 17.2 oranges left.\
The rest of the oranges are good, so the number of good oranges is 17.2.\
The answer is 17.2.\
Question: A basket contains 25 oranges among which 1 is bad, 20% are unripe, 2 are sour and the rest are good. How many oranges are good? [(Hint: The answer is near to [2, 17.2]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [2, 17.2]{style="color: red"}. With the Answer Hints: [2, 17.2]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
There are 25 oranges in the basket.\
1 is bad, so there are 24 oranges left.\
20% of 24 oranges are unripe, so 20% of 24 = 4.8 oranges are unripe.\
2 oranges are sour, so there are 24-4.8-2 = 17.2 oranges left.\
These 17.2 oranges are good.\
The answer is 17.2.\

---

Question: If the probability that Stock A will increase in value during the next month is 0.56, and the probability that Stock B will increase in value during the next month is 0.74. What is the greatest value for the probability that neither of these two events will occur? Answer Choices: (A) 0.22 (B) 0.26 (C) 0.37 (D) 0.46 (E) 0.63\
A: Let's think step by step\
The probability that Stock A will not increase in value during the next month is 1 - 0.56 = 0.44\
The probability that Stock B will not increase in value during the next month is 1 - 0.74 = 0.26\
The probability that neither of these two events will occur is the product of the two probabilities, which is 0.44 x 0.26 = 0.1144.\
The greatest value for the probability that neither of these two events will occur is 0.1144.\
The answer is (A), 0.22.\
Question: If the probability that Stock A will increase in value during the next month is 0.56, and the probability that Stock B will increase in value during the next month is 0.74. What is the greatest value for the probability that neither of these two events will occur? Answer Choices: (A) 0.22 (B) 0.26 (C) 0.37 (D) 0.46 (E) 0.63 [(Hint: The answer is near to [(A)]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [(A)]{style="color: red"}. With the Answer Hints: [(A)]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
The probability that neither of these two events will occur is 1 - (0.56 + 0.74) = 1 - 1.30 = 0.30\
The greatest value for the probability that neither of these two events will occur is 0.30.\
The answer is (A), 0.22.\

---

## Response when Miss Hint for GPT-3.5 Text-Divinci-003

---

Question: Jerry has two pools, both with leaks emptying them out at 4 gallons/minute. 4 minutes ago, the big pool had twice as much water as the small pool. Now the big pool has four times as much water as the small pool. How much water does the small pool have now? [(Hint: The answer is near to ).]{style="color: blue"}

A: [We know the Answer Hints: [16]{style="color: red"}. With the Answer Hints: [16]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
4 minutes ago, the big pool had twice as much water as the small pool.\
This means that the small pool had 4 gallons of water.\
In 4 minutes, the big pool has lost 4 gallons x 4 minutes = 16 gallons of water.\
The small pool has also lost 4 gallons x 4 minutes = 16 gallons of water.\
Therefore, the small pool now has 4 gallons - 16 gallons = -12 gallons of water.\
Since it is impossible to have negative gallons of water, the small pool must have 0 gallons of water.\
The answer is 0.

---

# Standard Prompt

## For AddSub, MultiArith, SingleEQ, SVAMP and GSM8K

**Base Standard**

---

Q: There are 15 trees in the grove. Grove workers will plant trees in the grove today. After they are done, there will be 21 trees. How many trees did the grove workers plant today?\
A: The answer is 6.

Q: If there are 3 cars in the parking lot and 2 more cars arrive, how many cars are in the parking lot? A: The answer is 5.

Q: Leah had 32 chocolates and her sister had 42. If they ate 35, how many pieces do they have left in total?\
A: The answer is 39.

Q: Jason had 20 lollipops. He gave Denny some lollipops. Now Jason has 12 lollipops. How many lollipops did Jason give to Denny?\
A: The answer is 8.

Q: Shawn has five toys. For Christmas, he got two toys each from his mom and dad. How many toys does he have now?\
A: The answer is 9.

Q: There were nine computers in the server room. Five more computers were installed each day, from monday to thursday. How many computers are now in the server room?\
A: The answer is 29.

Q: Michael had 58 golf balls. On tuesday, he lost 23 golf balls. On wednesday, he lost 2 more. How many golf balls did he have at the end of wednesday?\
A: The answer is 33.

Q: Olivia has \```latex $23. She bought five bagels for \$ ```3 each. How much money does she have left?\
A: The answer is 8.

---

**Progressive-Hint Prompting Standard (PHP-Standard)**

---

Q: There are 15 trees in the grove. Grove workers will plant trees in the grove today. After they are done, there will be 21 trees. How many trees did the grove workers plant today? [(Hint: The answer is near to [6]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [6]{style="color: red"}. With the Answer Hints: [6]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is 6.

Q: If there are 3 cars in the parking lot and 2 more cars arrive, how many cars are in the parking lot? [(Hint: The answer is near to [10, 8]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [10, 8]{style="color: red"}. With the Answer Hints: [10, 8]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is 5.

Q: Leah had 32 chocolates and her sister had 42. If they ate 35, how many pieces do they have left in total? [(Hint: The answer is near to [30, 35]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [30, 35]{style="color: red"}. With the Answer Hints: [30, 35]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is 39.

Q: Jason had 20 lollipops. He gave Denny some lollipops. Now Jason has 12 lollipops. How many lollipops did Jason give to Denny? [(Hint: The answer near to 8, 12).]{style="color: blue"}\
A: [We know the Answer Hints: [8, 12]{style="color: red"}. With the Answer Hints: [8, 12]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is 8.

Q: Shawn has five toys. For Christmas, he got two toys each from his mom and dad. How many toys does he have now? [(Hint: The answer is near to [9, 5]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [9, 5]{style="color: red"}. With the Answer Hints: [9, 5]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is 9.

Q: There were nine computers in the server room. Five more computers were installed each day, from monday to thursday. How many computers are now in the server room? [(Hint: The answer is near to [20]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [20]{style="color: red"}. With the Answer Hints: [20]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is 29.

Q: Michael had 58 golf balls. On tuesday, he lost 23 golf balls. On wednesday, he lost 2 more. How many golf balls did he have at the end of wednesday? [(Hint: The answer is near to 45).]{style="color: blue"}\
A: [We know the Answer Hints: [45]{style="color: red"}. With the Answer Hints: [45]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is 33.

Q: Olivia has \```latex $23. She bought five bagels for \$ ```3 each. How much money does she have left? [(Hint: The answer is near to [8]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [8]{style="color: red"}. With the Answer Hints: [8]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is 8.

---

## For AQuA

**Base Standard**

---

Q: John found that the average of 15 numbers is 40. If 10 is added to each number then the mean of the numbers is? Answer Choices: (a) 50 (b) 45 (c) 65 (d) 78 (e) 64\
A: The answer is (a).

Q: If a / b = 3/4 and 8a + 5b = 22,then find the value of a. Answer Choices: (a) 1/2 (b) 3/2 (c) 5/2 (d) 4/2 (e) 7/2\
A: The answer is (b).

Q: A person is traveling at 20 km/hr and reached his destiny in 2.5 hr then find the distance? Answer Choices: (a) 53 km (b) 55 km (c) 52 km (d) 60 km (e) 50 km\
A: The answer is (e).

Q: How many keystrokes are needed to type the numbers from 1 to 500? Answer Choices: (a) 1156 (b) 1392 (c) 1480 (d) 1562 (e) 1788\
A: The answer is (b).

---

**Progressive-Hint Prompting Standard (PHP-Standard)**

---

Q: John found that the average of 15 numbers is 40. If 10 is added to each number then the mean of the numbers is? [(Hint: The answer is near to [(a)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 50 (b) 45 (c) 65 (d) 78 (e) 64\
A: [We know the Answer Hints: [(a)]{style="color: red"}. With the Answer Hints: [(a)]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is (a).

Q: If a / b = 3/4 and 8a + 5b = 22,then find the value of a. [(Hint: The answer is near to [(b)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 1/2 (b) 3/2 (c) 5/2 (d) 4/2 (e) 7/2\
A: [We know the Answer Hints: [(b)]{style="color: red"}. With the Answer Hints: [(b)]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is (b).

Q: A person is traveling at 20 km/hr and reached his destiny in 2.5 hr then find the distance? [(Hint: The answer is near to [(d), (c)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 53 km (b) 55 km (c) 52 km (d) 60 km (e) 50 km\
A: [We know the Answer Hints: [(d), (c)]{style="color: red"}. With the Answer Hints: [(d), (c)]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is (e).

Q: How many keystrokes are needed to type the numbers from 1 to 500? [(Hint: The answer is near to [(a)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 1156 (b) 1392 (c) 1480 (d) 1562 (e) 1788\
A: [We know the Answer Hints: [(a)]{style="color: red"}. With the Answer Hints: [(a)]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is (b).

Q: John found that the average of 15 numbers is 40. If 10 is added to each number then the mean of the numbers is? [(Hint: The answer is near to [(a), (d)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 50 (b) 45 (c) 65 (d) 78 (e) 64\
A: [We know the Answer Hints: [(a), (d)]{style="color: red"}. With the Answer Hints: [(a), (d)]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is (a).

Q: If a / b = 3/4 and 8a + 5b = 22,then find the value of a. [(Hint: The answer is near to (a)).]{style="color: blue"}\
Answer Choices: (a) 1/2 (b) 3/2 (c) 5/2 (d) 4/2 (e) 7/2\
A: [We know the Answer Hints: [(a)]{style="color: red"}. With the Answer Hints: [(a)]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is (b).

Q: A person is traveling at 20 km/hr and reached his destiny in 2.5 hr then find the distance? [(Hint: The answer is near to (b)).]{style="color: blue"}\
Answer Choices: (a) 53 km (b) 55 km (c) 52 km (d) 60 km (e) 50 km\
A: [We know the Answer Hints: [(b)]{style="color: red"}. With the Answer Hints: [(b)]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is (e).

Q: How many keystrokes are needed to type the numbers from 1 to 500? [(Hint: The answer is near to (b), (a)).]{style="color: blue"}\
Answer Choices: (a) 1156 (b) 1392 (c) 1480 (d) 1562 (e) 1788\
A: [We know the Answer Hints: [(b), (a)]{style="color: red"}. With the Answer Hints: [(b), (a)]{style="color: red"}, we will answer the question.]{style="color: blue"} The answer is (b).

---

# Chain-Of-Thought Prompt

## For AddSub, MultiArith, SingleEQ, SVAMP and GSM8K

**Base Chain-Of-Thought**

---

Q: There are 15 trees in the grove. Grove workers will plant trees in the grove today. After they are done, there will be 21 trees. How many trees did the grove workers plant today?\
A: There are 15 trees originally. Then there were 21 trees after the Grove workers planted some more. So there must have been 21 - 15 = 6 trees that were planted. The answer is 6.

Q: If there are 3 cars in the parking lot and 2 more cars arrive, how many cars are in the parking lot? A: There are originally 3 cars. Then 2 more cars arrive. Now 3 + 2 = 5 cars are in the parking lot. The answer is 5.

Q: Leah had 32 chocolates and her sister had 42. If they ate 35, how many pieces do they have left in total?\
A: Originally, Leah had 32 chocolates and her sister had 42. So in total they had 32 + 42 = 74. After eating 35, they had 74 - 35 = 39 pieces left in total. The answer is 39.

Q: Jason had 20 lollipops. He gave Denny some lollipops. Now Jason has 12 lollipops. How many lollipops did Jason give to Denny?\
A: Jason had 20 lollipops originally. Then he had 12 after giving some to Denny. So he gave Denny 20 - 12 = 8 lollipops. The answer is 8.

Q: Shawn has five toys. For Christmas, he got two toys each from his mom and dad. How many toys does he have now?\
A: Shawn started with 5 toys. He then got 2 toys each from his mom and dad. So he got 2 \* 2 = 4 more toys. Now he has 5 + 4 = 9 toys. The answer is 9.

Q: There were nine computers in the server room. Five more computers were installed each day, from monday to thursday. How many computers are now in the server room?\
A: There were originally 9 computers. For each day from monday to thursday, 5 more computers were installed. So 4 \* 5 = 20 computers were added. Now 9 + 20 = 29 computers are now in the server room. The answer is 29.

Q: Michael had 58 golf balls. On tuesday, he lost 23 golf balls. On wednesday, he lost 2 more. How many golf balls did he have at the end of wednesday?\
A: Michael started with 58 golf balls. He lost 23 on Tuesday, and lost 2 more on wednesday. So he had 58 - 23 = 35 at the end of Tuesday, and 35 - 2 = 33 at the end of wednesday. The answer is 33.

Q: Olivia has \```latex $23. She bought five bagels for \$ ```3 each. How much money does she have left?\
A: Olivia had 23 dollars. She bought 5 bagels for 3 dollars each. So she spent 5 \* 3 = 15 dollars. Now she has 23 - 15 = 8 dollars left. The answer is 8.

---

**Progressive-Hint Prompting Chain-Of-Thought (PHP-CoT)**

---

Q: There are 15 trees in the grove. Grove workers will plant trees in the grove today. After they are done, there will be 21 trees. How many trees did the grove workers plant today? [(Hint: The answer is near to [6]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [6]{style="color: red"}. With the Answer Hints: [6]{style="color: red"}, we will answer the question.]{style="color: blue"} There are 15 trees originally. Then there were 21 trees after the Grove workers planted some more. So there must have been 21 - 15 = 6 trees that were planted. The answer is 6.

Q: If there are 3 cars in the parking lot and 2 more cars arrive, how many cars are in the parking lot? [(Hint: The answer is near to [10, 8]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [10, 8]{style="color: red"}. With the Answer Hints: [10, 8]{style="color: red"}, we will answer the question.]{style="color: blue"} There are originally 3 cars. Then 2 more cars arrive. Now 3 + 2 = 5 cars are in the parking lot. The answer is 5.

Q: Leah had 32 chocolates and her sister had 42. If they ate 35, how many pieces do they have left in total? [(Hint: The answer is near to [30, 35]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [30, 35]{style="color: red"}. With the Answer Hints: [30, 35]{style="color: red"}, we will answer the question.]{style="color: blue"} Originally, Leah had 32 chocolates and her sister had 42. So in total they had 32 + 42 = 74. After eating 35, they had 74 - 35 = 39 pieces left in total. The answer is 39.

Q: Jason had 20 lollipops. He gave Denny some lollipops. Now Jason has 12 lollipops. How many lollipops did Jason give to Denny? [(Hint: The answer near to [8, 12]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [8, 12]{style="color: red"}. With the Answer Hints: [8, 12]{style="color: red"}, we will answer the question.]{style="color: blue"} Jason had 20 lollipops originally. Then he had 12 after giving some to Denny. So he gave Denny 20 - 12 = 8 lollipops. The answer is 8.

Q: Shawn has five toys. For Christmas, he got two toys each from his mom and dad. How many toys does he have now? [(Hint: The answer is near to [9, 5]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [9, 5]{style="color: red"}. With the Answer Hints: [9, 5]{style="color: red"}, we will answer the question.]{style="color: blue"} Shawn started with 5 toys. He then got 2 toys each from his mom and dad. So he got 2 \* 2 = 4 more toys. Now he has 5 + 4 = 9 toys. The answer is 9.

Q: There were nine computers in the server room. Five more computers were installed each day, from monday to thursday. How many computers are now in the server room? [(Hint: The answer is near to [20]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [20]{style="color: red"}. With the Answer Hints: [20]{style="color: red"}, we will answer the question.]{style="color: blue"} There were originally 9 computers. For each day from monday to thursday, 5 more computers were installed. So 4 \* 5 = 20 computers were added. Now 9 + 20 = 29 computers are now in the server room. The answer is 29.

Q: Michael had 58 golf balls. On tuesday, he lost 23 golf balls. On wednesday, he lost 2 more. How many golf balls did he have at the end of wednesday? [(Hint: The answer is near to [45]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [45]{style="color: red"}. With the Answer Hints: [45]{style="color: red"}, we will answer the question.]{style="color: blue"} Michael started with 58 golf balls. He lost 23 on Tuesday, and lost 2 more on wednesday. So he had 58 - 23 = 35 at the end of Tuesday, and 35 - 2 = 33 at the end of wednesday. The answer is 33.

Q: Olivia has \```latex $23. She bought five bagels for \$ ```3 each. How much money does she have left? [(Hint: The answer is near to [8]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [8]{style="color: red"}. With the Answer Hints: [8]{style="color: red"}, we will answer the question.]{style="color: blue"} Olivia had 23 dollars. She bought 5 bagels for 3 dollars each. So she spent 5 \* 3 = 15 dollars. Now she has 23 - 15 = 8 dollars left. The answer is 8.

---

## For AQuA

**Base Chain-Of-Thought**

---

Q: John found that the average of 15 numbers is 40. If 10 is added to each number then the mean of the numbers is?\
Answer Choices: (a) 50 (b) 45 (c) 65 (d) 78 (e) 64\
A: If 10 is added to each number, then the mean of the numbers also increases by 10. So the new mean would be 50. The answer is (a).

Q: If a / b = 3/4 and 8a + 5b = 22,then find the value of a.\
Answer Choices: (a) 1/2 (b) 3/2 (c) 5/2 (d) 4/2 (e) 7/2\
A: a / b = 3/4, then b = 4a / 3. So 8a + 5(4a / 3) = 22. This simplifies to 8a + 20a / 3 = 22, which means 44a / 3 = 22. So a is equal to 3/2. The answer is (b).

Q: A person is traveling at 20 km/hr and reached his destiny in 2.5 hr then find the distance?\
Answer Choices: (a) 53 km (b) 55 km (c) 52 km (d) 60 km (e) 50 km\
A: The distance that the person traveled would have been 20 km/hr \* 2.5 hrs = 50 km. The answer is (e).

Q: How many keystrokes are needed to type the numbers from 1 to 500?\
Answer Choices: (a) 1156 (b) 1392 (c) 1480 (d) 1562 (e) 1788\
A: There are 9 one-digit numbers from 1 to 9. There are 90 two-digit numbers from 10 to 99. There are 401 three-digit numbers from 100 to 500. 9 + 90(2) + 401(3) = 1392. The answer is (b).

---

**Progressive-Hint Prompting Chain-Of-Thought (PHP-CoT)**

---

Q: John found that the average of 15 numbers is 40. If 10 is added to each number then the mean of the numbers is? [(Hint: The answer is near to [(a)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 50 (b) 45 (c) 65 (d) 78 (e) 64\
A: [We know the Answer Hints: [(a)]{style="color: red"}. With the Answer Hints: [(a)]{style="color: red"}, we will answer the question.]{style="color: blue"} If 10 is added to each number, then the mean of the numbers also increases by 10. So the new mean would be 50. The answer is (a).

Q: If a / b = 3/4 and 8a + 5b = 22,then find the value of a. [(Hint: The answer is near to [(b)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 1/2 (b) 3/2 (c) 5/2 (d) 4/2 (e) 7/2\
A: [We know the Answer Hints: [(b)]{style="color: red"}. With the Answer Hints: [(b)]{style="color: red"}, we will answer the question.]{style="color: blue"} a / b = 3/4, then b = 4a / 3. So 8a + 5(4a / 3) = 22. This simplifies to 8a + 20a / 3 = 22, which means 44a / 3 = 22. So a is equal to 3/2. The answer is (b).

Q: A person is traveling at 20 km/hr and reached his destiny in 2.5 hr then find the distance? [(Hint: The answer is near to [(d), (c)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 53 km (b) 55 km (c) 52 km (d) 60 km (e) 50 km\
A: [We know the Answer Hints: [(d), (c)]{style="color: red"}. With the Answer Hints: [(d), (c)]{style="color: red"}, we will answer the question.]{style="color: blue"} The distance that the person traveled would have been 20 km/hr \* 2.5 hrs = 50 km. The answer is (e).

Q: How many keystrokes are needed to type the numbers from 1 to 500? [(Hint: The answer is near to [(a)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 1156 (b) 1392 (c) 1480 (d) 1562 (e) 1788\
A: [We know the Answer Hints: [(a)]{style="color: red"}. With the Answer Hints: [(a)]{style="color: red"}, we will answer the question.]{style="color: blue"} There are 9 one-digit numbers from 1 to 9. There are 90 two-digit numbers from 10 to 99. There are 401 three-digit numbers from 100 to 500. 9 + 90(2) + 401(3) = 1392. The answer is (b).

Q: John found that the average of 15 numbers is 40. If 10 is added to each number then the mean of the numbers is? [(Hint: The answer is near to [(a), (d)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 50 (b) 45 (c) 65 (d) 78 (e) 64\
A: [We know the Answer Hints: [(a), (d)]{style="color: red"}. With the Answer Hints: [(a), (d)]{style="color: red"}, we will answer the question.]{style="color: blue"} If 10 is added to each number, then the mean of the numbers also increases by 10. So the new mean would be 50. The answer is (a).

Q: If a / b = 3/4 and 8a + 5b = 22,then find the value of a. [(Hint: The answer is near to [(a)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 1/2 (b) 3/2 (c) 5/2 (d) 4/2 (e) 7/2\
A: [We know the Answer Hints: [(a)]{style="color: red"}. With the Answer Hints: [(a)]{style="color: red"}, we will answer the question.]{style="color: blue"} a / b = 3/4, then b = 4a / 3. So 8a + 5(4a / 3) = 22. This simplifies to 8a + 20a / 3 = 22, which means 44a / 3 = 22. So a is equal to 3/2. The answer is (b).

Q: A person is traveling at 20 km/hr and reached his destiny in 2.5 hr then find the distance? [(Hint: The answer is near to [(b)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 53 km (b) 55 km (c) 52 km (d) 60 km (e) 50 km\
A: [We know the Answer Hints: [(b)]{style="color: red"}. With the Answer Hints: [(b)]{style="color: red"}, we will answer the question.]{style="color: blue"} The distance that the person traveled would have been 20 km/hr \* 2.5 hrs = 50 km. The answer is (e).

Q: How many keystrokes are needed to type the numbers from 1 to 500? [(Hint: The answer is near to [(b), (a)]{style="color: red"}).]{style="color: blue"}\
Answer Choices: (a) 1156 (b) 1392 (c) 1480 (d) 1562 (e) 1788\
A: [We know the Answer Hints: [(b), (a)]{style="color: red"}. With the Answer Hints: [(b), (a)]{style="color: red"}, we will answer the question.]{style="color: blue"} There are 9 one-digit numbers from 1 to 9. There are 90 two-digit numbers from 10 to 99. There are 401 three-digit numbers from 100 to 500. 9 + 90(2) + 401(3) = 1392. The answer is (b).

---

# Complex Chain-Of-Thought Prompt

## For AddSub, MultiArith, SingleEQ, SVAMP and GSM8K

**Base Complex Chain-Of-Thought**

---

Question: Angelo and Melanie want to plan how many hours over the next week they should study together for their test next week. They have 2 chapters of their textbook to study and 4 worksheets to memorize. They figure out that they should dedicate 3 hours to each chapter of their textbook and 1.5 hours for each worksheet. If they plan to study no more than 4 hours each day, how many days should they plan to study total over the next week if they take a 10-minute break every hour, include 3 10-minute snack breaks each day, and 30 minutes for lunch each day?\
A: Let's think step by step. Angelo and Melanie think they should dedicate 3 hours to each of the 2 chapters, 3 hours x 2 chapters = 6 hours total.\
For the worksheets they plan to dedicate 1.5 hours for each worksheet, 1.5 hours x 4 worksheets = 6 hours total.\
Angelo and Melanie need to start with planning 12 hours to study, at 4 hours a day, 12 / 4 = 3 days.\
However, they need to include time for breaks and lunch. Every hour they want to include a 10-minute break, so 12 total hours x 10 minutes = 120 extra minutes for breaks.\
They also want to include 3 10-minute snack breaks, 3 x 10 minutes = 30 minutes.\
And they want to include 30 minutes for lunch each day, so 120 minutes for breaks + 30 minutes for snack breaks + 30 minutes for lunch = 180 minutes, or 180 / 60 minutes per hour = 3 extra hours.\
So Angelo and Melanie want to plan 12 hours to study + 3 hours of breaks = 15 hours total. They want to study no more than 4 hours each day, 15 hours / 4 hours each day = 3.75 They will need to plan to study 4 days to allow for all the time they need.\
The answer is 4

Question: Mark's basketball team scores 25 2 pointers, 8 3 pointers and 10 free throws. Their opponents score double the 2 pointers but half the 3 pointers and free throws. What's the total number of points scored by both teams added together?\
A: Let's think step by step\
Mark's team scores 25 2 pointers, meaning they scored 25\*2= 50 points in 2 pointers.\
His team also scores 6 3 pointers, meaning they scored 8\*3= 24 points in 3 pointers\
They scored 10 free throws, and free throws count as one point so they scored 10\*1=10 points in free throws.\
All together his team scored 50+24+10= 84 points\
Mark's opponents scored double his team's number of 2 pointers, meaning they scored 50\*2=100 points in 2 pointers.\
His opponents scored half his team's number of 3 pointers, meaning they scored 24/2= 12 points in 3 pointers.\
They also scored half Mark's team's points in free throws, meaning they scored 10/2=5 points in free throws.\
All together Mark's opponents scored 100+12+5=117 points\
The total score for the game is both team's scores added together, so it is 84+117=201 points\
The answer is 201

Question: Bella has two times as many marbles as frisbees. She also has 20 more frisbees than deck cards. If she buys 2/5 times more of each item, what would be the total number of the items she will have if she currently has 60 marbles?\
A: Let's think step by step\
When Bella buys 2/5 times more marbles, she'll have increased the number of marbles by 2/5\*60 = 24\
The total number of marbles she'll have is 60+24 = 84\
If Bella currently has 60 marbles, and she has two times as many marbles as frisbees, she has 60/2 = 30 frisbees.\
If Bella buys 2/5 times more frisbees, she'll have 2/5\*30 = 12 more frisbees.\
The total number of frisbees she'll have will increase to 30+12 = 42\
Bella also has 20 more frisbees than deck cards, meaning she has 30-20 = 10 deck cards\
If she buys 2/5 times more deck cards, she'll have 2/5\*10 = 4 more deck cards.\
The total number of deck cards she'll have is 10+4 = 14\
Together, Bella will have a total of 14+42+84 = 140 items\
The answer is 140

Question: A group of 4 fruit baskets contains 9 apples, 15 oranges, and 14 bananas in the first three baskets and 2 less of each fruit in the fourth basket. How many fruits are there?\
A: Let's think step by step\
For the first three baskets, the number of apples and oranges in one basket is 9+15=24\
In total, together with bananas, the number of fruits in one basket is 24+14=38 for the first three baskets.\
Since there are three baskets each having 38 fruits, there are 3\*38=114 fruits in the first three baskets.\
The number of apples in the fourth basket is 9-2=7\
There are also 15-2=13 oranges in the fourth basket\
The combined number of oranges and apples in the fourth basket is 13+7=20\
The fourth basket also contains 14-2=12 bananas.\
In total, the fourth basket has 20+12=32 fruits.\
The four baskets together have 32+114=146 fruits.\
The answer is 146

Question: You can buy 4 apples or 1 watermelon for the same price. You bought 36 fruits evenly split between oranges, apples and watermelons, and the price of 1 orange is \```latex $0.50. How much does 1 apple cost if your total bill was \$ ```66?\
A: Let's think step by step\
If 36 fruits were evenly split between 3 types of fruits, then I bought 36/3 = 12 units of each fruit\
If 1 orange costs \```latex $0.50 then 12 oranges will cost \$ ```0.50 \* 12 = \$6\
If my total bill was \```latex $66 and I spent \$ ```6 on oranges then I spent \```latex $66 - $ ```6 =$`<!-- -->`{=html}60 on the other 2 fruit types.\
Assuming the price of watermelon is W, and knowing that you can buy 4 apples for the same price and that the price of one apple is A, then 1W=4A\
If we know we bought 12 watermelons and 12 apples for \```latex $60, then we know that \$ ```60 = 12W + 12A\
Knowing that 1W=4A, then we can convert the above to \$60 = 12(4A) + 12A\
```latex $60 = 48A + 12A\\$ ```
`<!-- -->`{=html}60 = 60A\
Then we know the price of one apple (A) is \```latex $60/60= \$ ```1\
The answer is 1

Question: Susy goes to a large school with 800 students, while Sarah goes to a smaller school with only 300 students. At the start of the school year, Susy had 100 social media followers. She gained 40 new followers in the first week of the school year, half that in the second week, and half of that in the third week. Sarah only had 50 social media followers at the start of the year, but she gained 90 new followers the first week, a third of that in the second week, and a third of that in the third week. After three weeks, how many social media followers did the girl with the most total followers have? A: Let's think step by step\
After one week, Susy has 100+40 = 140 followers.\
In the second week, Susy gains 40/2 = 20 new followers.\
In the third week, Susy gains 20/2 = 10 new followers.\
In total, Susy finishes the three weeks with 140+20+10 = 170 total followers.\
After one week, Sarah has 50+90 = 140 followers.\
After the second week, Sarah gains 90/3 = 30 followers.\
After the third week, Sarah gains 30/3 = 10 followers.\
So, Sarah finishes the three weeks with 140+30+10 = 180 total followers.\
Thus, Sarah is the girl with the most total followers with a total of 180.\
The answer is 180

Question: Sam bought a dozen boxes, each with 30 highlighter pens inside, for \```latex $10 each box. He rearranged five of these boxes into packages of six highlighters each and sold them for \$ ```3 per package. He sold the rest of the highlighters separately at the rate of three pens for \$2. How much profit did he make in total, in dollars?\
A: Let's think step by step\
Sam bought 12 boxes x ```latex $10 =$ ````<!-- -->`{=html}120 worth of highlighters.\
He bought 12 \* 30 = 360 highlighters in total.\
Sam then took 5 boxes × 6 highlighters/box = 30 highlighters.\
He sold these boxes for 5 \* \```latex $3 = \$ `15\
After selling these 5 boxes there were 360 - 30 = 330 highlighters remaining.\
These form 330 / 3 = 110 groups of three pens.\
He sold each of these groups for \`latex $2 each, so made 110 \* 2 = \$ `220 from them.\
In total, then, he earned \`latex $220 + \$ `15 = \$235.\
Since his original cost was \`latex $120, he earned \$ `235 - \`latex $120 = \$ ```115 in profit.\
The answer is 115

Question: In a certain school, 2/3 of the male students like to play basketball, but only 1/5 of the female students like to play basketball. What percent of the population of the school do not like to play basketball if the ratio of the male to female students is 3:2 and there are 1000 students?\
A: Let's think step by step\
The students are divided into 3 + 2 = 5 parts where 3 parts are for males and 2 parts are for females.\
Each part represents 1000/5 = 200 students.\
So, there are 3 x 200 = 600 males.\
And there are 2 x 200 = 400 females.\
Hence, 600 x 2/3 = 400 males play basketball.\
And 400 x 1/5 = 80 females play basketball.\
A total of 400 + 80 = 480 students play basketball.\
Therefore, 1000 - 480 = 520 do not like to play basketball.\
The percentage of the school that do not like to play basketball is 520/1000 \* 100 = 52 The answer is 52\

---

**Progressive-Hint Prompting Complex Chain-Of-Thought (PHP-Complex CoT)**

Question: Angelo and Melanie want to plan how many hours over the next week they should study together for their test next week. They have 2 chapters of their textbook to study and 4 worksheets to memorize. They figure out that they should dedicate 3 hours to each chapter of their textbook and 1.5 hours for each worksheet. If they plan to study no more than 4 hours each day, how many days should they plan to study total over the next week if they take a 10-minute break every hour, include 3 10-minute snack breaks each day, and 30 minutes for lunch each day? [(Hint: The answer is near to [4]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [4]{style="color: red"}. With the Answer Hints: [4]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step.\
Angelo and Melanie think they should dedicate 3 hours to each of the 2 chapters, 3 hours x 2 chapters = 6 hours total.\
For the worksheets they plan to dedicate 1.5 hours for each worksheet, 1.5 hours x 4 worksheets = 6 hours total.\
Angelo and Melanie need to start with planning 12 hours to study, at 4 hours a day, 12 / 4 = 3 days.\
However, they need to include time for breaks and lunch. Every hour they want to include a 10-minute break, so 12 total hours x 10 minutes = 120 extra minutes for breaks.\
They also want to include 3 10-minute snack breaks, 3 x 10 minutes = 30 minutes.\
And they want to include 30 minutes for lunch each day, so 120 minutes for breaks + 30 minutes for snack breaks + 30 minutes for lunch = 180 minutes, or 180 / 60 minutes per hour = 3 extra hours.\
So Angelo and Melanie want to plan 12 hours to study + 3 hours of breaks = 15 hours total.\
They want to study no more than 4 hours each day, 15 hours / 4 hours each day = 3.75\
They will need to plan to study 4 days to allow for all the time they need.\
The answer is 4

Question: Mark's basketball team scores 25 2 pointers, 8 3 pointers and 10 free throws. Their opponents score double the 2 pointers but half the 3 pointers and free throws. What's the total number of points scored by both teams added together?[(Hint: The answer is near to [201]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [201]{style="color: red"}. With the Answer Hints: [201]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
Mark's team scores 25 2 pointers, meaning they scored 25\*2= 50 points in 2 pointers.\
His team also scores 6 3 pointers, meaning they scored 8\*3= 24 points in 3 pointers\
They scored 10 free throws, and free throws count as one point so they scored 10\*1=10 points in free throws.\
All together his team scored 50+24+10= 84 points\
Mark's opponents scored double his team's number of 2 pointers, meaning they scored 50\*2=100 points in 2 pointers.\
His opponents scored half his team's number of 3 pointers, meaning they scored 24/2= 12 points in 3 pointers.\
They also scored half Mark's team's points in free throws, meaning they scored 10/2=5 points in free throws\
All together Mark's opponents scored 100+12+5=117 points\
The total score for the game is both team's scores added together, so it is 84+117=201 points\
The answer is 201

Question: Bella has two times as many marbles as frisbees. She also has 20 more frisbees than deck cards. If she buys 2/5 times more of each item, what would be the total number of the items she will have if she currently has 60 marbles? [(Hint: The answer is near to [160,145]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [160, 145]{style="color: red"}. With the Answer Hints: [160, 145]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
When Bella buys 2/5 times more marbles, she'll have increased the number of marbles by 2/5\*60 = 24\
The total number of marbles she'll have is 60+24 = 84\
If Bella currently has 60 marbles, and she has two times as many marbles as frisbees, she has 60/2 = 30 frisbees.\
If Bella buys 2/5 times more frisbees, she'll have 2/5\*30 = 12 more frisbees.\
The total number of frisbees she'll have will increase to 30+12 = 42\
Bella also has 20 more frisbees than deck cards, meaning she has 30-20 = 10 deck cards\
If she buys 2/5 times more deck cards, she'll have 2/5\*10 = 4 more deck cards.\
The total number of deck cards she'll have is 10+4 = 14\
Together, Bella will have a total of 14+42+84 = 140 items\
The answer is 140

Question: A group of 4 fruit baskets contains 9 apples, 15 oranges, and 14 bananas in the first three baskets and 2 less of each fruit in the fourth basket. How many fruits are there? [(Hint: The answer is near to [93, 141]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [93, 141]{style="color: red"}. With the Answer Hints: [93, 141]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
For the first three baskets, the number of apples and oranges in one basket is 9+15=24\
In total, together with bananas, the number of fruits in one basket is 24+14=38 for the first three baskets.\
Since there are three baskets each having 38 fruits, there are 3\*38=114 fruits in the first three baskets.\
The number of apples in the fourth basket is 9-2=7\
There are also 15-2=13 oranges in the fourth basket\
The combined number of oranges and apples in the fourth basket is 13+7=20\
The fourth basket also contains 14-2=12 bananas.\
In total, the fourth basket has 20+12=32 fruits.\
The four baskets together have 32+114=146 fruits.\
The answer is 146

Question: You can buy 4 apples or 1 watermelon for the same price. You bought 36 fruits evenly split between oranges, apples and watermelons, and the price of 1 orange is \```latex $0.50. How much does 1 apple cost if your total bill was \$ `66? [(Hint: The answer is near to [1, 5]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [1, 5]{style="color: red"}. With the Answer Hints: [1, 5]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
If 36 fruits were evenly split between 3 types of fruits, then I bought 36/3 = 12 units of each fruit\
If 1 orange costs \`latex $0.50 then 12 oranges will cost \$ `0.50 \* 12 = \$6\
If my total bill was \`latex $66 and I spent \$ `6 on oranges then I spent \`latex $66 - \$ `6 = \$60 on the other 2 fruit types.\
Assuming the price of watermelon is W, and knowing that you can buy 4 apples for the same price and that the price of one apple is A, then 1W=4A\
 If we know we bought 12 watermelons and 12 apples for \`latex $60, then we know that \$ `60 = 12W + 12A\
Knowing that 1W=4A, then we can convert the above to \$60 = 12(4A) + 12A\
\$60 = 48A + 12A\
\$60 = 60A\
Then we know the price of one apple (A) is \`latex $60/60= \$ ```1\
The answer is 1

Question: Susy goes to a large school with 800 students, while Sarah goes to a smaller school with only 300 students. At the start of the school year, Susy had 100 social media followers. She gained 40 new followers in the first week of the school year, half that in the second week, and half of that in the third week. Sarah only had 50 social media followers at the start of the year, but she gained 90 new followers the first week, a third of that in the second week, and a third of that in the third week. After three weeks, how many social media followers did the girl with the most total followers have? [(Hint: The answer is near to [180, 160]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [180, 160]{style="color: red"}. With the Answer Hints: [180, 160]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
After one week, Susy has 100+40 = 140 followers.\
In the second week, Susy gains 40/2 = 20 new followers.\
In the third week, Susy gains 20/2 = 10 new followers.\
In total, Susy finishes the three weeks with 140+20+10 = 170 total followers.\
After one week, Sarah has 50+90 = 140 followers.\
After the second week, Sarah gains 90/3 = 30 followers.\
After the third week, Sarah gains 30/3 = 10 followers.\
So, Sarah finishes the three weeks with 140+30+10 = 180 total followers.\
Thus, Sarah is the girl with the most total followers with a total of 180.\
The answer is 180\
Question: Sam bought a dozen boxes, each with 30 highlighter pens inside, for \```latex $10 each box. He rearranged five of these boxes into packages of six highlighters each and sold them for \$ `3 per package. He sold the rest of the highlighters separately at the rate of three pens for \$2. How much profit did he make in total, in dollars? [(Hint: The answer is near to [120]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [120]{style="color: red"}. With the Answer Hints: [120]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
Sam bought 12 boxes x \`latex $10 = \$ `120 worth of highlighters.\
He bought 12 \* 30 = 360 highlighters in total.\
Sam then took 5 boxes × 6 highlighters/box = 30 highlighters.\
He sold these boxes for 5 \* \`latex $3 = \$ `15\
After selling these 5 boxes there were 360 - 30 = 330 highlighters remaining.\
These form 330 / 3 = 110 groups of three pens.\
He sold each of these groups for \`latex $2 each, so made 110 \* 2 = \$ `220 from them.\
In total, then, he earned \`latex $220 + \$ `15 = \$235.\
Since his original cost was \`latex $120, he earned \$ `235 - \`latex $120 = \$ ```115 in profit.\
The answer is 115

Question: In a certain school, 2/3 of the male students like to play basketball, but only 1/5 of the female students like to play basketball. What percent of the population of the school do not like to play basketball if the ratio of the male to female students is 3:2 and there are 1000 students? [(Hint: The answer is near to [45]{style="color: red"}).]{style="color: blue"}\
A: [We know the Answer Hints: [45]{style="color: red"}. With the Answer Hints: [45]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
The students are divided into 3 + 2 = 5 parts where 3 parts are for males and 2 parts are for females.\
Each part represents 1000/5 = 200 students.\
So, there are 3 x 200 = 600 males.\
And there are 2 x 200 = 400 females.\
Hence, 600 x 2/3 = 400 males play basketball.\
And 400 x 1/5 = 80 females play basketball.\
A total of 400 + 80 = 480 students play basketball.\
Therefore, 1000 - 480 = 520 do not like to play basketball.\
The percentage of the school that do not like to play basketball is 520/1000 \* 100 = 52\
The answer is 52

---

## For AQuA

**Base Complex Chain-Of-Thought**

---

Question: there were 35 students in a hostel . due to the admission of 7 new students the expenses of the mess were increased by rs . 84 per day while the average expenditure per head diminished by re 1 . what was the original expenditure of the mess ? Options: (a) rs 450 (b) rs 920 (c) rs 550 (d) rs . 630 (e) none of these\
A: Let's think step by step let the original average expenditure be rs . x then , 42 ( x - 1 ) - 35 x = 84 7 x = 126 x = 18 therefore original expenditure = rs . ( 35 \* 18 ) = rs . 630. The answer is (d), rs . 630

Question: a train 200 m long passes a man , running at 5 km / hr in the same direction in which the train is going , in 10 seconds . the speed of the train is ? Options: (a) 28 (b) 50 (c) 77 (d) 22 (e) 12\
A: Let's think step by step speed of the train relative to man = ( 200 / 10 ) m / sec = ( 20 ) m / sec. `latex $[$ ` ( 20 ) \* ( 18 / 5 ) `latex $]$ ` km / hr = 72 km / hr. let the speed of the train be x km / hr. then , relative speed = ( x - 5 ) km / hr. x - 5 = 72, x = 77 km / hr . The answer is (c), 77

Question: solution x contains 20 % of material a and 80 % of material b . solution y contains 30 % of material a and 70 % of material b . a mixture of both these solutions contains 22 % of material a in the final product . how much solution x is present in the mixture ?\
Options: (a) 40 % (b) 60 % (c) 80 % (d) 100 % (e) 110 %\
A: Let's think step by step\
we can assume the total weight of the mixture = 100\
conc of a in the final mixture = 22\
let weight of a in the mixture be x.\
conc given = 20% = 0.2\
therefore , weight of b = 100 - x.\
conc given = 30% = 0.3\
now , accordding to the problem, 0.2 x + 0.3 ( 100 - x ) = 22\
solving , we get x = 80\
since we assumed the weight of the mixture = 100, therefore presence of a in the mixture = 80%.\
The answer is (c), 80%

Question: a trader sells 40 metres of cloth for rs . 8200 at a profit of rs . 35 per metre of cloth . how much profit will the trder earn on 40 metres of cloth ?\
Options: (a) rs . 950 (b) rs . 1500 (c) rs . 1000 (d) rs . 1400 (e) none of these\
A: Let's think step by step\
price of 1 metre cloth = 8200 / 40 = rs 205\
cost of 1 metre cloth = rs 205 -- 35 = rs 170\
cost on 40 metres = 170 x 40 = rs . 6800\
profit earned on 40 metres cloth = rs . 8200 -- rs . 6800 = rs . 1400\
The answer is (d), rs . 1400

Question: if x \< y \< z and y - x \> 5 , where x is an even integer and y and z are odd integers , what is the least possible value s of z - x ?\
Options: (a) 6 (b) 7 (c) 8 (d) 9 (e) 10\
A: Let's think step by step\
We know x \< y \< z\
to find the least possible value for z - x, we need to find the values for z and x that can be closest to each other.\
if x is some even number, then what could be minimum possible odd z.\
if x is some even number, y - x \> 5 ; y \> x + 5\
minimum value for y = x + 5 + 2 = x + 7\
(note : x + 5 is as even + odd = odd and nearest odd greater than x + 5 is x + 5 + 2)\
minimum value for z = y + 2 = x + 7 + 2 = x + 9\
(note : z = y + 2 because both z and y are odd, difference between two odd numbers is 2)\
s = z - x = x + 9 - x = 9\
The answer is (d), 9

Question: what is the difference between the c . i . on rs . 6000 for 1 1 / 2 years at 4 % per annum compounded yearly and half - yearly ?\
Options: (a) s . 2.04 (b) s . 2.08 (c) s . 2.02 (d) s . 2.83 (e) s . 2.45\
A: Let's think step by step\
c . i . when interest is compounded yearly = \[ 6000 \* ( 1 + 4 / 100 ) \* ( 1 + ( 1 / 2 \* 4 ) / 100 \] = 6000 \* 26 / 25 \* 51 / 50 = rs . 6364.8\
c . i . when interest is compounded half - yearly = \[ 6000 \* ( 1 + 2 / 100 ) 2 \] = ( 6000 \* 51 / 50 \* 51 / 50 \* 51 / 50 ) = rs . 6367.25\
difference = ( 6367.25 - 6364.8 ) = rs . 2.45.\
The answer is (e), s . 2.45

Question: the average weight of a , b and c is 45 kg . if the average weight of a and b be 40 kg and that of b and c be 45 kg , then the weight of b is :\
Options: (a) 31 kg (b) 32 kg (c) 33 kg (d) 35 kg (e) none of these\
A: Let's think step by step\
let a , b , c represent their respective weights.\
then , we have : a + b + c = ( 45 x 3 ) = 135 ... ( i )\
a + b = ( 40 x 2 ) = 80 ... ( ii )\
b + c = ( 45 x 2 ) = 90 ... ( iii )\
adding ( ii ) and ( iii ), we get : a + 2 b + c = 170 ... ( iv )\
subtracting ( i ) from ( iv ), we get : b = 35.\
b' s weight = 35 kg .\
The answer is (d), 35 kg

Question: the compound and the simple interests on a certain sum at the same rate of interest for two years are rs . 11730 and rs . 10200 respectively . find the sum\
Options: (a) rs . 17037 (b) rs . 17000 (c) rs . 17276 (d) rs . 170287 (e) rs . 171881\
A: Let's think step by step\
the simple interest for the first year is 10200 / 2 is rs . 5100\
and compound interest for first year also is rs . 5100.\
the compound interest for second year on rs . 5100 for one year\
so rate of the interest = ( 100 \* 1530 ) / ( 5100 \* 1 ) = 30% p\
so p = ( 100 \* 10200 ) / ( 30 \* 2 ) = rs . 17000\
The answer is (b), rs . 17000

---

**Progressive-Hint Prompting Complex Chain of Thought (PHP-Complex CoT)**

Question: there were 35 students in a hostel . due to the admission of 7 new students the expenses of the mess were increased by rs . 84 per day while the average expenditure per head diminished by re 1 . what was the original expenditure of the mess ? [(Hint: The answer is near to [(d)]{style="color: red"}).]{style="color: blue"}\
Options: (a) rs 450 (b) rs 920 (c) rs 550 (d) rs . 630 (e) none of these\
A: [We know the Answer Hints: [(d)]{style="color: red"}. With the Answer Hints: [(d)]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
let the original average expenditure be rs . x\
then , 42 ( x - 1 ) - 35 x = 84 7 x = 126\
x = 18\
therefore original expenditure = rs . ( 35 \* 18 ) = rs . 630.\
The answer is (d), rs . 630\
Question: a train 200 m long passes a man , running at 5 km / hr in the same direction in which the train is going , in 10 seconds . the speed of the train is ? [(Hint: The answer is near to [(c)]{style="color: red"}).]{style="color: blue"}\
Options: (a) 28 (b) 50 (c) 77 (d) 22 (e) 12\
A: [We know the Answer Hints: [(c)]{style="color: red"}. With the Answer Hints: [(c)]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
speed of the train relative to man = ( 200 / 10 ) m / sec = ( 20 ) m / sec.\
`latex $[$ ` ( 20 ) \* ( 18 / 5 ) `latex $]$ ` km / hr = 72 km / hr.\
let the speed of the train be x km / hr.\
then , relative speed = ( x - 5 ) km / hr.\
x - 5 = 72, x = 77 km / hr .\
The answer is (c), 77

Question: solution x contains 20 % of material a and 80 % of material b . solution y contains 30 % of material a and 70 % of material b . a mixture of both these solutions contains 22 % of material a in the final product . how much solution x is present in the mixture ? [(Hint: The answer is near to [(a)]{style="color: red"}).]{style="color: blue"}\
Options: (a) 40 % (b) 60 % (c) 80 % (d) 100 % (e) 110 %\
A: [We know the Answer Hints: [(a)]{style="color: red"}. With the Answer Hints: [(a)]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
we can assume the total weight of the mixture = 100\
conc of a in the final mixture = 22\
let weight of a in the mixture be x.\
conc given = 20% = 0.2\
therefore , weight of b = 100 - x.\
conc given = 30% = 0.3\
now , accordding to the problem, 0.2 x + 0.3 ( 100 - x ) = 22\
solving , we get x = 80\
since we assumed the weight of the mixture = 100, therefore presence of a in the mixture = 80%.\
The answer is (c), 80%

Question: a trader sells 40 metres of cloth for rs . 8200 at a profit of rs . 35 per metre of cloth . how much profit will the trder earn on 40 metres of cloth ? [(Hint: The answer is near to [(c)]{style="color: red"}).]{style="color: blue"}\
Options: (a) rs . 950 (b) rs . 1500 (c) rs . 1000 (d) rs . 1400 (e) none of these\
A: [We know the Answer Hints: [(c)]{style="color: red"}. With the Answer Hints: [(c)]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
price of 1 metre cloth = 8200 / 40 = rs 205\
cost of 1 metre cloth = rs 205 -- 35 = rs 170\
cost on 40 metres = 170 x 40 = rs . 6800\
profit earned on 40 metres cloth = rs . 8200 -- rs . 6800 = rs . 1400\
The answer is (d), rs . 1400

Question: if x \< y \< z and y - x \> 5 , where x is an even integer and y and z are odd integers , what is the least possible value s of z - x ? [(Hint: The answer is near to [(a), (c)]{style="color: red"}).]{style="color: blue"}\
Options: (a) 6 (b) 7 (c) 8 (d) 9 (e) 10\
A: [We know the Answer Hints: [(a), (c)]{style="color: red"}. With the Answer Hints: [(a), (c)]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
We know x \< y \< z\
to find the least possible value for z - x, we need to find the values for z and x that can be closest to each other.\
if x is some even number, then what could be minimum possible odd z.\
if x is some even number, y - x \> 5 ; y \> x + 5\
minimum value for y = x + 5 + 2 = x + 7\
(note : x + 5 is as even + odd = odd and nearest odd greater than x + 5 is x + 5 + 2)\
minimum value for z = y + 2 = x + 7 + 2 = x + 9\
(note : z = y + 2 because both z and y are odd, difference between two odd numbers is 2)\
s = z - x = x + 9 - x = 9\
The answer is (d), 9

Question: what is the difference between the c . i . on rs . 6000 for 1 1 / 2 years at 4 % per annum compounded yearly and half - yearly ? [(Hint: The answer is near to [(e), (d)]{style="color: red"}).]{style="color: blue"}\
Options: (a) s . 2.04 (b) s . 2.08 (c) s . 2.02 (d) s . 2.83 (e) s . 2.45\
A: [We know the Answer Hints: [(e), d)]{style="color: red"}. With the Answer Hints: [(e), (d)]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
c . i . when interest is compounded yearly = \[ 6000 \* ( 1 + 4 / 100 ) \* ( 1 + ( 1 / 2 \* 4 ) / 100 \] = 6000 \* 26 / 25 \* 51 / 50 = rs . 6364.8\
c . i . when interest is compounded half - yearly = \[ 6000 \* ( 1 + 2 / 100 ) 2 \] = ( 6000 \* 51 / 50 \* 51 / 50 \* 51 / 50 ) = rs . 6367.25\
difference = ( 6367.25 - 6364.8 ) = rs . 2.45.\
The answer is (e), s . 2.45

Question: the average weight of a , b and c is 45 kg . if the average weight of a and b be 40 kg and that of b and c be 45 kg , then the weight of b is : [(Hint: The answer is near to [(d), (b)]{style="color: red"}).]{style="color: blue"}\
Options: (a) 31 kg (b) 32 kg (c) 33 kg (d) 35 kg (e) none of these\
A: [We know the Answer Hints: [(d), (b)]{style="color: red"}. With the Answer Hints: [(d), (b)]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
let a , b , c represent their respective weights.\
then , we have : a + b + c = ( 45 x 3 ) = 135 ... ( i )\
a + b = ( 40 x 2 ) = 80 ... ( ii )\
b + c = ( 45 x 2 ) = 90 ... ( iii )\
adding ( ii ) and ( iii ), we get : a + 2 b + c = 170 ... ( iv )\
subtracting ( i ) from ( iv ), we get : b = 35.\
b' s weight = 35 kg .\
The answer is (d), 35 kg

Question: the compound and the simple interests on a certain sum at the same rate of interest for two years are rs . 11730 and rs . 10200 respectively . find the sum [(Hint: The answer is near to [(e), (c)]{style="color: red"}).]{style="color: blue"}\
Options: (a) rs . 17037 (b) rs . 17000 (c) rs . 17276 (d) rs . 170287 (e) rs . 171881\
A: [We know the Answer Hints: [(e), (c)]{style="color: red"}. With the Answer Hints: [(e), (c)]{style="color: red"}, we will answer the question.]{style="color: blue"}\
Let's think step by step\
the simple interest for the first year is 10200 / 2 is rs . 5100\
and compound interest for first year also is rs . 5100.\
the compound interest for second year on rs . 5100 for one year\
so rate of the interest = ( 100 \* 1530 ) / ( 5100 \* 1 ) = 30% p\
so p = ( 100 \* 10200 ) / ( 30 \* 2 ) = rs . 17000\
The answer is (b), rs . 17000

---
